  '
  ' MCP 4822 dual 12 bit DAC demo program by matherp@TBS
  ' modified for Maximites MMBasic 4.5D (twofingers@TBS 2/2015)
  ' http://www.thebackshed.com/forum/forum_posts.asp?TID=7154&KW=4822
  '
  ' 4822-Registers
  '    A/B -- GA SHDN D11 D10 D9 D8 D7 D6 D5 D4 D3 D2 D1 D0
  ' Bit 15                                               00
  '
  ' Provided AS IS without any warranty.
  ' Use it at your own risk. All information is provided for
  ' educational purposes only! 
    
  '
  ' Pin assignments on MCP4822
  '

          ' DAC pin 1 = VDD 3V3! With gain x2 and VDD 5V you will destroy your MM inputs!!
  cs  =11 ' DAC pin 2 output(MM)
  SCK =12 ' DAC Pin 3 output(MM)
  SDI =13 ' DAC Pin 4 output(MM)
  ldac=14 ' DAC Pin 5 output(MM)
  voutb=3 ' DAC Pin 6  input(MM)
          ' DAC Pin 7 = GND
  vouta=2 ' DAC Pin 8  input(MM)
  RX  =15 ' for SPI()

  '
  'Pin use
  '
  ' CS, SCK, SDI, lDac can be any DOUT, RX any DIN
  SetPin cs,   dout
  SetPin SCK,  dout
  SetPin SDI,  dout
  SetPin ldac, dout
  SetPin vouta,ain
  SetPin voutb,ain
  SetPin RX,   din ' N/C, unused


  Dim gain
  Dim DACa ,DACb
  Dim voltage
  Dim i

  INIT:
  Pin(cs)=1    'set chip select inactive
  Pin(ldac)=1  'set ldac inactive



MAIN:
  For gain=1 To 2
    Print "Gain = ",gain
    Print "Measurement resolution is 3.3/1024 = 0.003V"
    If gain=1 Then Print "DAC resolution is       2.048/4096 = 0.0005V"
    If gain=2 Then Print "DAC resolution is       4.096/4096 = 0.001V"
    Print " DAC-A   ADC   -|-  DAC-B   ADC"
    For i=0 To 20
      voltage=i*gain*0.1
      DACa=setdac(0,gain,voltage)
      DACb=setdac(1,gain,2*gain-voltage)


      Print " "Format$(DACa,"%0.1f")"    "Format$(Pin(vouta),"%0.3f")"  -|-  ";
      Print Format$(DACb,"%0.1f")"    "Format$(Pin(voutb),"%0.3f")
      Pause 00
    Next i
    Print ""
  Next gain

  ' Speedtest
  Dim a(2000)
  Timer=0
  For i=1 To 2000
  Next i
  Print Timer

  For i = 1 To 2000
    a(i)=i/1000
  Next i

  Timer=0
  junk=0
  For i=0 To 2000
    SetdacA(a(i))
  Next i
  Print
  Print Timer
  
  Pause 2000
    ShutDnDac(0)
  ShutDnDac(1)  
End
'-------------------------------------------------------


  '
  ' Sub to set DAC A channel, optimised for speed (~2000 op/sec)
  ' no error handling!
Sub SetdacA(v) 'v=volt, DAC=A(or 0), Gain=2
  Pin(cs)=0:junk=SPI(rx,SDI,SCK,v*1000 Or &B0001000000000000,,,16):Pin(cs)=1
  Pulse ldac,0.005
End Sub


  '
  ' Sub to shutdown the DAC 0 or 1 (A or B)
  '
Sub ShutDnDac(DAC)
  Local junk
  Pin(cs)=0
  If DAC=0 Then
    junk=SPI(rx,SDI,SCK,&B0000000000000000,,,16)
  Else
    junk=SPI(rx,SDI,SCK,&B1000000000000000,,,16)
  EndIf
  Pin(cs)=1
  Pulse ldac,0.005
End Sub


  '
  ' Function to set output on one of the DAC channels
  '
Function setdac(DAC, dacgain, volts)
  Local dacdata, junk
  dacdata=Cint(volts * 2000 / dacgain)
  If dacdata>4095 Or dacdata<0 Or DAC<0 Or DAC>1 Or dacgain<1 Or dacgain>2 Then
    setDAC=0
    Exit Function
  EndIf
  setdac= dacdata /2000 * dacgain
  If DAC=0 Then
    dacdata=dacdata Or &B0011000000000000
  Else
    dacdata=dacdata Or &B1011000000000000
  EndIf
  If dacgain=2 Then dacdata=dacdata And &B1101111111111111

  Pin(cs)=0
    junk = SPI(rx,SDI,SCK,dacdata,,,16) 'using defaults: speed=H (3 MHz), mode=3
  Pin(cs)=1
  Pulse ldac,0.005
End Function
